# Copyright 2020 Autodesk, Inc.  All rights reserved.
#
# Use of this software is subject to the terms of the Autodesk license
# agreement provided at the time of installation or download, or which
# otherwise accompanies this software in either electronic or hard copy form.

from ctypes import *
from .arnold_common import ai
from .ai_types import *

AiMalloc_func = ai.AiMalloc_func
AiMalloc_func.argtypes = [c_ulong, AtPythonString, c_int, AtPythonString]
AiMalloc_func.restype = c_void_p

def AiMalloc(size):
    return AiMalloc_func(size, '', 0, '')

AiRealloc_func = ai.AiRealloc_func
AiRealloc_func.argtypes = [c_void_p, c_ulong, AtPythonString, c_int, AtPythonString]
AiRealloc_func.restype = c_void_p

def AiRealloc(addr, size):
    return AiRealloc_func(addr, size, '', 0, '')

AiFree_func = ai.AiFree_func
AiFree_func.argtypes = [c_void_p, AtPythonString, c_int, AtPythonString]

def AiFree(addr):
    AiFree_func(addr, '', 0, '')

AiAddMemUsage = ai.AiAddMemUsage
AiAddMemUsage.argtypes = [c_longlong, AtString]
